Attribute VB_Name = "Modsoundcontrol"
Option Explicit

Private Const soundFileName As String = "soundsettings.dat"

Private Function GetSoundFilePath() As String
    GetSoundFilePath = App.Path & IIf(Right$(App.Path, 1) = "\", "", "\") & soundFileName
End Function

Public Function IsSoundEnabled() As Boolean
    Dim fnum As Integer, val As Integer
    On Error GoTo fallback

    If Dir(GetSoundFilePath()) <> "" Then
        fnum = FreeFile
        Open GetSoundFilePath() For Input As #fnum
        Input #fnum, val
        Close #fnum
        IsSoundEnabled = (val = 1)
        Exit Function
    End If

fallback:
    IsSoundEnabled = True ' Default to ON
End Function

Public Sub SaveSoundSetting(ByVal enabled As Boolean)
    Dim fnum As Integer
    On Error Resume Next
    fnum = FreeFile
    Open GetSoundFilePath() For Output As #fnum
    Write #fnum, IIf(enabled, 1, 0)
    Close #fnum
End Sub
